#!/bin/bash

PROJECT_NAME="PaymentSDK"
UNIVERSAL_OUTPUTFOLDER="build/iOS-universal"

# make sure the output directory exists
mkdir -p "${UNIVERSAL_OUTPUTFOLDER}"

# Build Full Version Device and Simulator versions
xcodebuild archive \
    -project PaymentSDK.xcodeproj \
    -scheme PaymentSDK \
    -destination "generic/platform=iOS" \
    -archivePath "archives/PaymentSDK-iOS" \
	  SKIP_INSTALL=NO \
	  BUILD_LIBRARY_FOR_DISTRIBUTION=YES

xcodebuild archive \
    -project PaymentSDK.xcodeproj \
    -scheme PaymentSDK \
    -destination "generic/platform=iOS Simulator" \
    -archivePath "archives/PaymentSDK-iOS-Simulator" \
	  SKIP_INSTALL=NO \
	  BUILD_LIBRARY_FOR_DISTRIBUTION=YES
	  
# Create xcframework
rm -rf build/iOS-universal/PaymentSDK.xcframework
xcodebuild -create-xcframework \
    -archive archives/PaymentSDK-iOS.xcarchive -framework PaymentSDK.framework \
    -archive archives/PaymentSDK-iOS-Simulator.xcarchive -framework PaymentSDK.framework \
    -output build/iOS-universal/PaymentSDK.xcframework


# Move to Full
mkdir -p "${UNIVERSAL_OUTPUTFOLDER}/Full"
cp -R "${UNIVERSAL_OUTPUTFOLDER}/${PROJECT_NAME}.xcframework" "${UNIVERSAL_OUTPUTFOLDER}/Full/"


# Build for Non-MagTek
xcodebuild archive \
    -project PaymentSDK.xcodeproj \
    -scheme PaymentSDK-WDRelease \
    -destination "generic/platform=iOS" \
    -archivePath "archives/PaymentSDK-iOS" \
	  SKIP_INSTALL=NO \
	  BUILD_LIBRARY_FOR_DISTRIBUTION=YES 

xcodebuild archive \
    -project PaymentSDK.xcodeproj \
    -scheme PaymentSDK-WDRelease \
    -destination "generic/platform=iOS Simulator" \
    -archivePath "archives/PaymentSDK-iOS-Simulator" \
	  SKIP_INSTALL=NO \
	  BUILD_LIBRARY_FOR_DISTRIBUTION=YES 

# Copy the framework structure (from iphoneos build) to the universal folder
rm -rf build/iOS-universal/PaymentSDK.xcframework
xcodebuild -create-xcframework \
    -archive archives/PaymentSDK-iOS.xcarchive -framework PaymentSDK.framework \
    -archive archives/PaymentSDK-iOS-Simulator.xcarchive -framework PaymentSDK.framework \
    -output ${UNIVERSAL_OUTPUTFOLDER}/PaymentSDK.xcframework


# Move to Non-MagTek Directory
mkdir -p "${UNIVERSAL_OUTPUTFOLDER}/Non-MagTek"
cp -R "${UNIVERSAL_OUTPUTFOLDER}/${PROJECT_NAME}.xcframework" "${UNIVERSAL_OUTPUTFOLDER}/Non-MagTek/"

# Copy Additionaal Files
cp -R "./IDTech.bundle" "${UNIVERSAL_OUTPUTFOLDER}/Non-MagTek/${PROJECT_NAME}.xcframework/"
cp -R "./IDTech.bundle" "${UNIVERSAL_OUTPUTFOLDER}/Full/${PROJECT_NAME}.xcframework/"
 
